/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.netbeans.modules.groovy.editor.options.MarkOccurencesOptionsPanelController;
import org.netbeans.modules.groovy.editor.options.MarkOccurencesSettings;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MarkOccurencesPanel
extends JPanel {
    private static final boolean DEFAULT_VALUE = true;
    private List<JCheckBox> boxes;
    private MarkOccurencesOptionsPanelController controller;
    private JCheckBox keepMarksCheckBox;
    private JCheckBox onOffCheckBox;

    public MarkOccurencesPanel(MarkOccurencesOptionsPanelController controller) {
        this.initComponents();
        this.fillBoxes();
        this.addListeners();
        this.load(controller);
    }

    public void load(MarkOccurencesOptionsPanelController controller) {
        this.controller = controller;
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        for (JCheckBox box : this.boxes) {
            box.setSelected(node.getBoolean(box.getActionCommand(), true));
        }
        this.componentsSetEnabled();
    }

    public void store() {
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        for (JCheckBox box : this.boxes) {
            boolean original;
            boolean value = box.isSelected();
            if (value == (original = node.getBoolean(box.getActionCommand(), true))) continue;
            node.putBoolean(box.getActionCommand(), value);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean changed() {
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        for (JCheckBox box : this.boxes) {
            boolean original;
            boolean value = box.isSelected();
            if (value == (original = node.getBoolean(box.getActionCommand(), true))) continue;
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.onOffCheckBox = new JCheckBox();
        this.keepMarksCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }
        });
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.onOffCheckBox, (String)NbBundle.getMessage(MarkOccurencesPanel.class, (String)"CTL_OnOff_CheckBox"));
        this.onOffCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.onOffCheckBox, gridBagConstraints);
        this.onOffCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"MarkOccurrencesPanel.onOffCheckBox.AccessibleContext.accessibleName"));
        this.onOffCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"ACSD_OnOff_CB"));
        this.keepMarksCheckBox.setMnemonic('s');
        Mnemonics.setLocalizedText((AbstractButton)this.keepMarksCheckBox, (String)NbBundle.getMessage(MarkOccurencesPanel.class, (String)"MarkOccurencesPanel.keepMarksCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 8, 0);
        this.add((Component)this.keepMarksCheckBox, gridBagConstraints);
        this.keepMarksCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"MarkOccurencesPanel.keepMarksCheckBox.text"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"MarkOccurrencesPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"MarkOccurrencesPanel.AccessibleContext.accessibleDescription"));
    }

    private void fillBoxes() {
        this.boxes = new ArrayList<JCheckBox>();
        this.boxes.add(this.onOffCheckBox);
        this.boxes.add(this.keepMarksCheckBox);
        this.onOffCheckBox.setActionCommand("OnOff");
        this.keepMarksCheckBox.setActionCommand("KeepMarks");
    }

    private void addListeners() {
        CheckItemListener itemListener = new CheckItemListener();
        for (JCheckBox box : this.boxes) {
            box.addItemListener(itemListener);
        }
    }

    private void componentsSetEnabled() {
        for (int i = 1; i < this.boxes.size(); ++i) {
            this.boxes.get(i).setEnabled(this.onOffCheckBox.isSelected());
        }
    }

    private class CheckItemListener
    implements ItemListener {
        private CheckItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getSource() == MarkOccurencesPanel.this.onOffCheckBox) {
                MarkOccurencesPanel.this.componentsSetEnabled();
            }
            MarkOccurencesPanel.this.controller.changed();
        }
    }
}

